<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
* {
	box-sizing: border-box;
}
html {
	font-family: sans-serif;
	scroll-snap-type: mandatory;
	scroll-snap-points-y: repeat(100vh);
	scroll-snap-type: y mandatory;
}
section {
	border-bottom: 1px solid white;
	padding: 0px;
	height: 100vh;
	scroll-snap-align: start;
	text-align: center;
	position: relative;
}
h1	{
	position: absolute;
	top: 50%;
	transform: translateY(-50%);
	text-align: center;
	color: #000;
	width: 100%;
	left: 0;
	font-size: calc(1rem + 3vw);
}
video{
  width: 100%;
  height: 100%;
  margin-top:-30px;
  background: #313131;
}
.komentar{
    position:absolute;
    top:45%;
    right:20px;
    color:
}
.komentar a{
    color:#fff;
    font-size:30px;
    display:block;
    margin-bottom:10px
}
.keterangan{
    bottom: 140px;
    padding:0px 20px;
    position: absolute;
    color:#fff;
    text-align:left;
}
.sub-keterangan{
    display:block;
    padding:3px;
    background:#fff;
    text-align:left;
    background: rgba(0,0,0,0.3);
    border:1px solid #2c2c2c;
    margin-bottom:15px;
}
.sub-keterangan a{
    color:orange;
    text-align:left;
}
.keterangan span{
    color:#fff;
}
.muted{
    position: absolute;
    z-index: 1;
    top: 20px;
    right: 10px;
}
.audio-control {
  cursor:pointer;
  padding: 0px 15px 0px 10px;
  width:50px;
  background: rgba(0,0,0,0.5);
  color: #fff;
  border-radius: 4px;
  font-size:30px;
  display: inline-block;
}

.modal-bottom {
  position:fixed;
  top:auto;
  right:auto;
  left:auto;
  bottom:0;
  
}

.direct-chat-img {
    border-radius: 50%;
    float: left;
    width: 35px;
    height: 35px;
}

.direct-chat-msg{
    display: block;
    clear: both;
    min-height: 60px;
}

.comments-body{
    height: 240px;
    overflow-y: auto;
    padding: 0px 10px;
}

</style>

</head>
<body>
    <?php 
        $no = 1;
        foreach($records->result_array() as $row){
            echo "<section>
                <video playsinline autoplay muted class='myVideo$no' loop src='".base_url()."asset/img_video/$row[video]' controls type='video/mp4'></video>
                <div class='komentar'>
                    <a href='#' data-toggle='modal' data-target='.bs-example-modal-lgx' data-id='$row[id_produk_video]' class='comments'><span class='fa fa-comments'></span></a>
                    <a href=''><span data-id='".base_url()."produk/video?watch=$row[id_produk_video]' class='fa fa-share share_button'></span></a>
                </div>
                <div class='keterangan'>
                    <div class='sub-keterangan'><a href='".base_url()."produk/detail/$row[produk_seo]?v=true'>$row[judul_video]</a></div>
                    $row[keterangan_video]
                </div>
            </section>";
            $no++;
        }
    ?>
    
 
<div class="modal fade bs-example-modal-lgx" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"> 
  <div class="modal-dialog modal-lg modal-bottom" style='width:100%; margin:0px'>  
    <div class="modal-content" style='height:350px; padding:0px'>
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title" id="myModalLabel"></h4>
        </div>
        
        <div class="modal-body">
            <div class='comments-body'></div>
        </div> 
        
        <div class="modal-footer" style='display:block'>
                <div class="input-group">
                    <input type="hidden" name="id_produk_video" class='id_produk_video'>
                    <input type="text" name="isi_komentar" placeholder="Tambahkan Komentar ..." class="form-control isi_komentar" required>
                    <span class="input-group-btn">
                        <button style='padding: 5px 15px !important;' type="button" class="btn btn-success btn-flat sendMessage"><span class="fa fa-send"></span></button>
                    </span>
                </div>
        </div>
    </div>
  </div>
</div>    
    
    
<script> 
async function AndroidNativeShare(Title,URL,Description){
  if(typeof navigator.share==='undefined' || !navigator.share){
    alert('Your browser does not support Android Native Share, it\'s tested on chrome 63+');
  } else if(window.location.protocol!='https:'){
    alert('Android Native Share support only on Https:// protocol');
  } else {
    if(typeof URL==='undefined'){
      URL = window.location.href;
    }
    if(typeof Title==='undefined'){
      Title = document.title;
    }
    if(typeof Description==='undefined'){
      Description = 'Share your thoughts about '+Title;
    } 
    const TitleConst = Title;
    const URLConst = URL;
    const DescriptionConst = Description;
     
    try{
      await navigator.share({title:TitleConst, text:DescriptionConst, url:URLConst});
    } catch (error) {
    console.log('Error sharing: ' + error);
    return;
    }   
  }
} 

$(function(){
    $(document).on('click','.comments',function(e){
        e.preventDefault();
        $(".id_produk_video").val($(this).attr('data-id'));
        $.post("video_commentsx",
            {id:$(this).attr('data-id')},
            function(html){
                //console.log(html);
                $(".comments-body").html(html);
            }   
        );
    });
});

$(document).ready(function(){
    function show_comments(id_produk_video){
        $.ajax({
            url   : '<?php echo site_url("produk/video_comments"); ?>?id='+id_produk_video,
            type  : 'GET',
            async : true,
            dataType : 'json',
            success : function(data){
                //console.log(data);
                var html = '';
                var i;
                url = '<?= base_url() ?>';
                if (data.length==0){
                    html += '<center>Yuk, Jadi yang pertama untuk memberikan komentar pada video ini!</center>';
                }
                for(i=0; i<data.length; i++){
                    if (data[i].foto==''){
                        foto = 'https://members.phpmu.com/asset/members/members0.png';
                    }else{
                        foto = url+'asset/foto_user/'+data[i].foto;
                    }
                    
                    html += '<div class="spacer"></div><div class="direct-chat-msg">'+
                                '<div class="direct-chat-info clearfix">'+
                                    '<img class="direct-chat-img mr-2 float-left" src="'+foto+'" alt="Message User">'+
                                    '<span class="font-weight-bold">'+data[i].nama_lengkap+'</span>'+
                                    '<span class="float-right"><small>'+ timeAgo(Date.parse(data[i].waktu_komentar)) +'</small></span>'+
                                    '<div class="direct-chat-text" style="margin-left:40px; margin-bottom:10px">'+
                                    '<span>'+data[i].isi_komentar+'</span>'+
                                    '</div>'+
                                '</div>'+
                            '</div>';
                }
                $('.comments-body').html(html);
            }
        });
    }
            
    $('.sendMessage').on('click',function(){
        var id_produk_video = $('.id_produk_video').val();
    	var isi_komentar = $('.isi_komentar').val();
    	if (isi_komentar==''){
    	    $(".isi_komentar").focus();
    	}else{
            $.ajax({
                url    : '<?php echo site_url("produk/video_comments_send");?>',
                method : 'POST',
                data   : {id_produk_video: id_produk_video, isi_komentar: isi_komentar},
                success: function(data){
                    $('.isi_komentar').val("");
                    show_comments(id_produk_video);
                    //console.log(data);
                }
            }); 
    	}
    });
});    

function timeAgo(date) {
    let minute = 60;
    let hour   = minute * 60;
    let day    = hour   * 24;
    let month  = day    * 30;
    let year   = day    * 365;

    let suffix = ' lalu';

    let elapsed = Math.floor((Date.now() - date) / 1000);

    if (elapsed < minute) {
        return 'Baru saja';
    }

    // get an array in the form of [number, string]
    let a = elapsed < hour  && [Math.floor(elapsed / minute), 'Menit'] ||
            elapsed < day   && [Math.floor(elapsed / hour), 'Jam']     ||
            elapsed < month && [Math.floor(elapsed / day), 'Hari']       ||
            elapsed < year  && [Math.floor(elapsed / month), 'Bulan']   ||
            [Math.floor(elapsed / year), 'Tahun'];

    // pluralise and append suffix
    return a[0] + ' ' + a[1] + (a[0] === 1 ? '' : '') + suffix;
}

$(".share_button").click(function(BodyEvent){
  var meta_desc,meta_title,meta_url
  if(document.querySelector('meta[property="og:description"]')!=null) {
    meta_desc = document.querySelector('meta[property="og:description"]').content;
  }
  if(document.querySelector('meta[property="og:title"]')!=null) {
    meta_title = document.querySelector('meta[property="og:title"]').content;
  }
  if($(this).data("id")!=null) {
    meta_url = $(this).data("id");
  }
  
  //alert($(this).data("id"));
  AndroidNativeShare(meta_title, meta_url,meta_desc); 
});




    function playPauseVideo() {
    let videos = document.querySelectorAll("video");
    i = 1;
    videos.forEach((video) => {
        // We can only control playback without insteraction if video is mute
        video.muted = true;
        
        // Play is a promise so we need to check we have it
        let playPromise = video.play();
        
        console.log(i);
        if (playPromise !== undefined) {
            playPromise.then((_) => {
                let observer = new IntersectionObserver(
                    (entries) => {
                        entries.forEach((entry) => {
                            if (entry.intersectionRatio !== 1) {
                                video.pause();
                                video.muted = false;
                            }else if (video.paused) {
                                video.play();
                                video.muted = false;
                            }
                        });
                    },
                    { threshold: 0.2 }
                );
                observer.observe(video);
            });
        }
        i++;
    });
    
}
// And you would kick this off where appropriate with:
playPauseVideo();
</script>    
</body>
</html>